function FigureS1(data)
fld_con = fieldnames(data.learnEffect);
titlestr = {'Without second vehicle - Yielding', 'Without second vehicle - Non-yielding','With second vehicle - Yielding', 'With second vehicle - Non-yielding'};
visAll(data.learnEffect, fld_con, titlestr);
end

function visAll(data, fld_con, titlestr)
figure;
for c=1:length(fld_con) % loop over 4 scenarios
    subplot(1,4,c);
    hold on;
    grid on;
    xlabel('Trial','FontSize',15,'FontWeight','bold');
    ylabel({'Crossing button press (%)'},'FontSize',15,'FontWeight','bold');
    title(titlestr{c},'FontSize',15,'FontWeight','bold');
    set(gca,'XTick',(1:1:4));
    set(gca,'FontSize',15);
    fld_map = fieldnames(data.(fld_con{c}));
    for m=1:length(fld_map) % loop over 3 mappings
        switch m
            case 1
                colour = [0, 0.45, 0.74];
            case 2
                colour = [0.85, 0.33, 0.10];
            case 3
                colour = [0.93, 0.69, 0.13];
        end

        plot(data.(fld_con{c}).(fld_map{m}),'o-','LineWidth',3,'MarkerSize',10,'color',colour);
    end
    ylim([10 91]);
    legend('Baseline','LTY','LATY','Location','southwest','FontSize',15,'FontWeight','bold');
end
end
